/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.BlockNoTraders;
import com.lothrazar.cyclic.block.CandlePeaceBlock;
import com.lothrazar.cyclic.block.generatorexpl.BlockDestruction;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSpawnEvents {
    @SubscribeEvent
    public void onExplosionEvent(ExplosionEvent.Start event) {
        Level world = event.getWorld();
        Integer radius = (Integer)BlockDestruction.RADIUS.get();
        Integer height = (Integer)BlockDestruction.HEIGHT.get();
        if (UtilWorld.doesBlockExist(world, new BlockPos(event.getExplosion().getPosition()), ((Block)BlockRegistry.ALTAR_DESTRUCTION.get()).m_49966_(), radius, height)) {
            ModCyclic.LOGGER.info(world.f_46443_ + " =clinet;Explosion cancelled " + event.getExplosion());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        MobSpawnType res = event.getSpawnReason();
        if (res == MobSpawnType.NATURAL || res == MobSpawnType.REINFORCEMENT || res == MobSpawnType.EVENT) {
            Integer radius = (Integer)CandlePeaceBlock.RADIUS.get();
            Integer height = (Integer)CandlePeaceBlock.HEIGHT.get();
            LivingEntity mob = event.getEntityLiving();
            if (CandlePeaceBlock.isBad(mob, res) && UtilWorld.doesBlockExist(mob.f_19853_, mob.m_142538_(), (BlockState)((Block)BlockRegistry.PEACE_CANDLE.get()).m_49966_().m_61124_((Property)BlockCyclic.LIT, (Comparable)Boolean.valueOf(true)), radius, height)) {
                ModCyclic.LOGGER.info(mob.m_142538_() + " Spawn cancelled by candle " + mob.m_6095_());
                event.setResult(Event.Result.DENY);
            }
            radius = (Integer)BlockNoTraders.RADIUS.get();
            height = (Integer)BlockNoTraders.HEIGHT.get();
            if (BlockNoTraders.isSpawnDenied(mob, res) && UtilWorld.doesBlockExist(mob.f_19853_, mob.m_142538_(), (BlockState)((Block)BlockRegistry.NO_SOLICITING.get()).m_49966_().m_61124_((Property)BlockNoTraders.LIT, (Comparable)Boolean.valueOf(true)), radius, height)) {
                ModCyclic.LOGGER.info("Spawn cancelled by altar " + mob.m_6095_());
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

